//+------------------------------------------------------------------+
//|                                      SMC Autotrader Momentum.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

extern double TakeProfit = 50;
extern double Lots = 8;
extern double InitialStop = 10;
extern double TrailingStop = 20;
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int init()
  {
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {
   int cnt, total, ticket, MinDist, tmp;
   double Spread;
   double ATR;
   double StopMA;
   double SetupHigh, SetupLow;
//----
   if(Bars < 100)
     {
       Print("bars less than 100");
       return(0);  
     }
// Miscellaneous setup stuff
   MinDist = MarketInfo(Symbol(), MODE_STOPLEVEL);
   Spread = (Ask - Bid);
// use an indicator for data values
   ATR = iATR(NULL, 0, 10, 0); // BE CAREFUL OF EFFECTING THE AUTO TRAIL STOPS
   StopMA = iMA(NULL, 0, 24, 0, MODE_SMA, PRICE_CLOSE, 0);
// ORDER CLOSURE
// If Orders are in force then check for closure against Technicals LONG & SHORT
// CLOSE LONG Entries
   total = OrdersTotal();
//----
   if(total > 0)
     { 
       for(cnt = 0; cnt < total; cnt++)
         {
           OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
           //----
           if(OrderType() == OP_BUY && OrderSymbol() == Symbol())
             {
               if(Close[0] < Close[20])
                 {                                 
                   // close LONG position
                   OrderClose(OrderTicket(), OrderLots(), Bid, 3, Violet); 
                 }
             }
           // CLOSE SHORT ENTRIES: 
           OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES); 
           //----
           if(OrderType() == OP_SELL && OrderSymbol() ==Symbol()) // check for symbol
             {
               if(Close[0] > Close[20])
                 {   
                   // close SHORT position
                   OrderClose(OrderTicket(), OrderLots(), Ask, 3, Violet); 
                 }
             }
         }  // for loop return
     }   // close 1st if 
// ORDER TRAILING STOP Adjustment
// TRAILING STOP: LONG
   if(0 == 1)  // This is used to turn the trailing stop on & off
     {
       total = OrdersTotal();
       //----
       if(total > 0)
         { 
           for(cnt = 0; cnt < total; cnt++)
             {
               OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
               //----
               if(OrderType() == OP_BUY && OrderSymbol() == Symbol() &&
                  Bid - OrderOpenPrice() > (Point*TrailingStop) &&
                  OrderStopLoss() < Bid - (Point*TrailingStop))
                 {
                   OrderModify(OrderTicket(), OrderOpenPrice(), Bid-Point*TrailingStop, 
                               OrderTakeProfit(), 0, White);
                   return(0);}
                 }
             }
           // TRAILING STOP: SHORT
           total = OrdersTotal();
           //----
           if(total > 0)
             { 
               for(cnt = 0; cnt < total; cnt++)
                 {
                   OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
                   //----
                   if(OrderType() == OP_SELL && OrderSymbol() == Symbol() &&
                      OrderOpenPrice()-Ask > (Point*TrailingStop) &&
                      OrderStopLoss() > Ask+(Point*TrailingStop))
                     {
                       OrderModify(OrderTicket(), OrderOpenPrice(), Ask + (Point*TrailingStop),
                                   OrderTakeProfit(), 0, Yellow);
                       return(0);
                     }
                 }
             }
         }  // end bracket for on/off switch
// END OF ORDER Closure routines & Stoploss changes
// START of NEW ORDERS
// NEW POSITIONS
//Possibly add in timer to stop multiple entries within Period
// Check Margin available
// ONLY ONE ORDER per SYMBOL
// Loop around orders to check symbol doesn't appear more than once
// Check for elapsed time from last entry to stop multiple entries on same bar
   if(0==1) // switch to turn ON/OFF history check
     {  
       total = HistoryTotal();
       //----
       if(total > 0)
         { 
           for(cnt = 0; cnt < total; cnt++)
             {
               //Needs to be next day not as below
               OrderSelect(cnt, SELECT_BY_POS, MODE_HISTORY);
               //----
               if(OrderSymbol() == Symbol()&& CurTime() - OrderCloseTime() < (Period() * 60))
                   return(0);
             }
         }
     }
   total = OrdersTotal();
//----
   if(total > 0)
     { 
       for(cnt = 0; cnt < total; cnt++)
         {
           OrderSelect(cnt, SELECT_BY_POS, MODE_TRADES);
           //----
           if(OrderSymbol() == Symbol()) 
               return(0);
         }
     }
//----
   if(AccountFreeMargin() < (1000*Lots))
     {
       Print("We have no money. Free Margin = ", AccountFreeMargin());
       return(0);
     }
//ENTRY RULES: LONG 
   if(Close[0] > Close[20])
     {
       //Bid-(Point*(MinDist+2))
       ticket = OrderSend(Symbol(), OP_BUY, Lots, Ask, 3, Bid - (InitialStop*Point), 
                          Ask+(TakeProfit*Point), "MaxMin Long", 16384, 0, Orange); 
       //----
       if(ticket > 0)
         {
           if(OrderSelect(ticket, SELECT_BY_TICKET, MODE_TRADES)) 
               Print("BUY order opened : ", OrderOpenPrice());
         }
       else 
           Print("Error opening BUY order : ", GetLastError()); 
       return(0); 
     } 
//ENTRY RULES: SHORT 
   if(Close[0] < Close[20])
     {
       ticket = OrderSend(Symbol(), OP_SELL, Lots, Bid, 3, Ask + (Point*InitialStop), 
                          Ask - (TakeProfit*Point), "MaxMin Short", 16384, 0, Red);
       //----
       if(ticket > 0)
         {
           if(OrderSelect(ticket, SELECT_BY_TICKET, MODE_TRADES)) 
               Print("SELL order opened : ", OrderOpenPrice());
         }
       else 
           Print("Error opening SELL order : ", GetLastError()); 
       return(0); 
     }
// End of PROGRAM
   return(0);
  }
//+------------------------------------------------------------------+